package org.beast.payment.channel.byteapp.model;

import lombok.Builder;
import lombok.Data;

@Builder
@Data
public class ByteAppPayNotifyReply {

    private Integer errNo;

    private String errTips;


    public static ByteAppPayNotifyReply success() {
        return ByteAppPayNotifyReply.builder()
                .errNo(0)
                .errTips("success")
                .build();
    }

    public static ByteAppPayNotifyReply failure(String message) {
        return ByteAppPayNotifyReply.builder()
                .errNo(-1)
                .errTips(message)
                .build();
    }
}
