package org.beast.payment.channel.byteapp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import lombok.extern.slf4j.Slf4j;
import org.beast.payment.channel.byteapp.exception.ByteAppPayException;
import org.beast.payment.channel.byteapp.model.ByteAppNotifyRequest;
import org.beast.payment.channel.byteapp.model.ByteAppPayNotify;

import java.util.Objects;

@Slf4j
public class ByteAppPayNotifyHandler {

    private ObjectMapper mapper;

    private ByteAppNotifyVerifier verifier;

    public ByteAppPayNotifyHandler(ByteAppNotifyVerifier verifier) {
        this.verifier = verifier;
        this.mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL)
                .setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE)
                .registerModule(new JavaTimeModule());
    }

    public ByteAppPayNotify parse(ByteAppNotifyRequest request) throws ByteAppPayException, JsonProcessingException {
        String type = request.getType();
        if (!Objects.equals(type, "payment")) {
             throw new ByteAppPayException("bytedance notify type is not 'payment'");
        }
        if (!verifier.verify(request)) {
            throw new ByteAppPayException("bytedance notify verify failure");
        }
        String message = request.getMsg();
        return parseMessage(message);
    }

    private ByteAppPayNotify parseMessage(String message) throws JsonProcessingException {
        return this.mapper.readValue(message, ByteAppPayNotify.class);
    }



}


