package org.beast.payment.channel.byteapp;

import lombok.Data;
import org.beast.payment.channel.AbstractClientFactory;
import org.springframework.lang.Nullable;

import javax.validation.constraints.NotBlank;

public class ByteAppPayClientFactory extends AbstractClientFactory<ByteAppPayClient, ByteAppPayClientFactory.Config> {


    @Override
    public ByteAppPayClient newClient(Config config) {
        var appId = config.appId;
        var salt = config.salt;
        var token = config.token;
        return new ByteAppPayClient(
                appId,
                salt,
                token
        );
    }

    @Data
    public static final class Config {

        @NotBlank
        private String appId;

        @NotBlank
        private String salt;

        @NotBlank
        private String token;

        @Nullable
        private String thirdpartyId;
    }
}
