package org.beast.payment.channel.byteapp;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import org.beast.payment.channel.byteapp.model.ByteAppNotifyRequest;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ByteAppNotifyVerifier {

    private String token;

    public ByteAppNotifyVerifier(String token) {
        this.token = token;
    }

    public boolean verify(ByteAppNotifyRequest request) {
        Integer timestamp = request.getTimestamp();
        String nonce = request.getNonce();
        String msg = request.getMsg();
        List<String> values = Lists.newArrayList();
        values.add(token);
        values.add(String.valueOf(timestamp));
        values.add(nonce);
        values.add(msg);
        Collections.sort(values);
        String content = Joiner.on("").join(values);
        String signature = Hashing.sha1().hashString(content, Charsets.UTF_8).toString();
        String messageSignature = request.getMsgSignature();
        return Objects.equals(signature, messageSignature);
    }
}
