package org.beast.payment.channel.byteapp;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;

import java.util.*;

public class ByteAppKeySigner {

    private String salt;

    public ByteAppKeySigner(String key) {
        this.salt = key;
    }

    public String sign(Map<String, ?> params) {
        Map<String, Object> paramsMap = Maps.newHashMap(params);
        paramsMap.remove("appId");
        List<String> values = Lists.newArrayList(params.values().stream()
                .filter(Objects::nonNull)
                .map(Object::toString)
                .filter(item -> {
                    return !Strings.isNullOrEmpty(item);
                })
                .toList());
        values.add(this.salt);
        Collections.sort(values);
        String content = Joiner.on("&").join(values);
        return Hashing.md5().hashString(content, Charsets.UTF_8).toString();
    }
}
