package org.beast.payment.channel.alipay;

import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import org.beast.payment.channel.AbstractClientFactory;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;


public class AlipayClientFactory extends AbstractClientFactory<AlipayClient, AlipayClientFactory.Config> {

    //沙箱环境-网关 https://docs.open.alipay.com/200/105311/
    public static final String SANDBOX_TARGET = "https://openapi.alipaydev.com/gateway.do";
    //正式环境-网关
    public static final String TARGET = "https://openapi.alipay.com/gateway.do";
    private static final String METHOD = "alipay.trade.page.pay";
    private static final String FORMAT = "json";
    public static final String CHARSET = "utf-8";
    public static final String SIGN_TYPE = "RSA2";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.of("UTC+08:00"));
    private static final String VERSION = "1.0";


    @Override
    public AlipayClient newClient(Config config) {
        String endpoint = config.endpoint;
        String appId = config.appId;
        String privateKey = config.privateKey;
        String publicKey = config.alipayPublicKey;
        return new DefaultAlipayClient(endpoint,
                appId,
                privateKey,
                FORMAT,
                CHARSET,
                publicKey,
                SIGN_TYPE);
    }


    public static final String APP_ID_NAME = "appId";
    public static final String ALIPAY_PUBLIC_KEY_NAME = "alipayPublicKey";
    public static final String DOMAIN_NAME = "domain";

    @Getter@Setter
    public static final class Config {
        @NotBlank
        private String endpoint;
        @NotBlank
        private String appId;
        @NotBlank
        private String privateKey;

        //回调验证 仅配置话
        @NotBlank
        private String alipayPublicKey;

        //回调域名 仅配置话
        @NotBlank
        private String domain;

    }
}
