package org.beast.payment.channel;

import com.google.common.collect.Maps;
import org.beast.data.config.Configurable;
import org.beast.data.config.ConfigurationUtils;

import java.util.Map;

public interface ClientFactory<T, C> extends Configurable<C> {

    T newClient(C config);

    default String name() {
        return this.getClass().getSimpleName().replace(ClientFactory.class.getSimpleName(), "");
    }


}
