/*
 * Decompiled with CFR 0.152.
 */
package org.beast.payment.channel.wechatv3;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;

public class WechatPrivateKeySigner {
    protected final PrivateKey privateKey;

    public WechatPrivateKeySigner(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String sign(String content) {
        try {
            byte[] message = content.getBytes(StandardCharsets.UTF_8);
            Signature sign = Signature.getInstance("SHA256withRSA");
            sign.initSign(this.privateKey);
            sign.update(message);
            return Base64.getEncoder().encodeToString(sign.sign());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301SHA256withRSA", e);
        }
        catch (SignatureException e) {
            throw new RuntimeException("\u7b7e\u540d\u8ba1\u7b97\u5931\u8d25", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u79c1\u94a5", e);
        }
    }
}

