/*
 * Decompiled with CFR 0.152.
 */
package org.beast.payment.channel.wechatv3;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import com.wechat.pay.contrib.apache.httpclient.exception.ParseException;
import com.wechat.pay.contrib.apache.httpclient.exception.ValidationException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.beast.payment.channel.wechatv3.model.WechatNotifyRequest;
import org.beast.payment.channel.wechatv3.model.WechatPayNotify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatPayNotifyHandler {
    private static final Logger log = LoggerFactory.getLogger(WechatPayNotifyHandler.class);
    private ObjectMapper mapper;
    private Verifier verifier;

    public WechatPayNotifyHandler(Verifier verifier) {
        this.verifier = verifier;
        this.mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).registerModule((Module)new JavaTimeModule());
    }

    public WechatPayNotify parse(WechatNotifyRequest request) throws IOException, ParseException, ValidationException {
        String signature;
        String serial;
        String body = request.getBody();
        String message = this.buildMessage(request);
        if (!this.validate(message, serial = request.getSerialNumber(), signature = request.getSignature())) {
            String errorMessage = String.format("\u89e3\u6790\u9a8c\u7b7e\u5931\u8d25\uff1aserial=[%s] message=[%s] sign=[%s]", serial, message, signature);
            throw new ValidationException(errorMessage);
        }
        return this.parseBody(body);
    }

    private boolean validate(String message, String serial, String signature) throws IOException {
        try {
            if (!this.verifier.verify(serial, message.getBytes(StandardCharsets.UTF_8), signature)) {
                throw WechatPayNotifyHandler.verifyFail("serial=[%s] message=[%s] sign=[%s]", serial, message, signature);
            }
        }
        catch (IllegalArgumentException e) {
            log.warn(e.getMessage());
            return false;
        }
        return true;
    }

    public <T> T decode(String body, Class<T> clazz) throws JsonProcessingException {
        return (T)this.mapper.readValue(body, clazz);
    }

    private WechatPayNotify parseBody(String body) throws ParseException {
        try {
            return (WechatPayNotify)this.mapper.readValue(body, WechatPayNotify.class);
        }
        catch (IOException exception) {
            throw new ParseException("\u89e3\u6790body\u5931\u8d25, body:" + body, (Throwable)exception);
        }
    }

    protected static IllegalArgumentException verifyFail(String message, Object ... args) {
        message = String.format(message, args);
        return new IllegalArgumentException("signature verify fail: " + message);
    }

    protected String buildMessage(WechatNotifyRequest request) throws IOException {
        String timestamp = request.getTimestamp();
        String nonce = request.getNonce();
        String body = request.getBody();
        return timestamp + "\n" + nonce + "\n" + body + "\n";
    }
}

