/*
 * Decompiled with CFR 0.152.
 */
package org.beast.payment.channel.wechatv3;

import com.wechat.pay.contrib.apache.httpclient.Credentials;
import com.wechat.pay.contrib.apache.httpclient.Validator;
import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.CertificatesVerifier;
import com.wechat.pay.contrib.apache.httpclient.auth.PrivateKeySigner;
import com.wechat.pay.contrib.apache.httpclient.auth.Signer;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Credentials;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Validator;
import com.wechat.pay.contrib.apache.httpclient.cert.CertificatesManager;
import com.wechat.pay.contrib.apache.httpclient.util.AesUtil;
import com.wechat.pay.contrib.apache.httpclient.util.PemUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.beast.payment.channel.AbstractClientFactory;
import org.beast.payment.channel.wechatv3.WechatPayClient;
import org.beast.payment.channel.wechatv3.WechatPrivateKeySigner;
import org.beast.payment.channel.wechatv3.api.Certificates;
import org.beast.payment.channel.wechatv3.model.PlainCertificateItem;
import org.springframework.util.ObjectUtils;

public class WechatPayClientFactory
extends AbstractClientFactory<WechatPayClient, Config> {
    public static final String TARGET = "https://api.mch.weixin.qq.com";

    @Override
    public WechatPayClient newClient(Config config) {
        String endpoint = config.endpoint;
        if (ObjectUtils.isEmpty((Object)endpoint)) {
            endpoint = TARGET;
        }
        WechatPayHttpClientBuilder builder = WechatPayHttpClientBuilder.create();
        String merchantId = config.merchantId;
        String merchantSerialNumber = config.merchantSerialNumber;
        String apiV3Key = config.apiV3Key;
        PrivateKey merchantPrivateKey = PemUtil.loadPrivateKey((String)config.merchantPrivateKey);
        builder = builder.withMerchant(merchantId, merchantSerialNumber, merchantPrivateKey);
        CertificatesManager certificatesManager = CertificatesManager.getInstance();
        certificatesManager.putMerchant(merchantId, (Credentials)new WechatPay2Credentials(merchantId, (Signer)new PrivateKeySigner(merchantSerialNumber, merchantPrivateKey)), apiV3Key.getBytes(StandardCharsets.UTF_8));
        Verifier verifier = certificatesManager.getVerifier(merchantId);
        builder = builder.withValidator((Validator)new WechatPay2Validator(verifier));
        AesUtil aesUtil = new AesUtil(apiV3Key.getBytes(StandardCharsets.UTF_8));
        WechatPrivateKeySigner signer = new WechatPrivateKeySigner(merchantPrivateKey);
        return new WechatPayClient(merchantId, endpoint, signer, verifier, aesUtil, builder);
    }

    private List<PlainCertificateItem> decryptAndValidate(String apiV3key, Certificates certList, CloseableHttpResponse response) throws GeneralSecurityException, IOException, IOException {
        ArrayList<PlainCertificateItem> plainCerts = new ArrayList<PlainCertificateItem>();
        ArrayList<X509Certificate> x509Certs = new ArrayList<X509Certificate>();
        AesUtil decryptor = new AesUtil(apiV3key.getBytes(StandardCharsets.UTF_8));
        for (Certificates.CertificateItem item : certList.getData()) {
            PlainCertificateItem plainCert = new PlainCertificateItem(item.getSerialNo(), item.getEffectiveTime(), item.getExpireTime(), decryptor.decryptToString(item.getEncryptCertificate().getAssociatedData().getBytes(StandardCharsets.UTF_8), item.getEncryptCertificate().getNonce().getBytes(StandardCharsets.UTF_8), item.getEncryptCertificate().getCiphertext()));
            System.out.println(plainCert.getPlainCertificate());
            ByteArrayInputStream inputStream = new ByteArrayInputStream(plainCert.getPlainCertificate().getBytes(StandardCharsets.UTF_8));
            X509Certificate x509Cert = PemUtil.loadCertificate((InputStream)inputStream);
            plainCerts.add(plainCert);
            x509Certs.add(x509Cert);
        }
        CertificatesVerifier verifier = new CertificatesVerifier(x509Certs);
        WechatPay2Validator validator = new WechatPay2Validator((Verifier)verifier);
        boolean isCorrectCert = validator.validate(response);
        System.out.println(isCorrectCert ? "=== validate success ===" : "=== validate failed ===");
        return isCorrectCert ? plainCerts : null;
    }

    public static final class Config {
        @Nullable
        private String endpoint;
        @NotBlank
        private String merchantId;
        @NotBlank
        private String merchantSerialNumber;
        @NotBlank
        private String merchantPrivateKey;
        @NotBlank
        private String apiV3Key;

        @Nullable
        public String getEndpoint() {
            return this.endpoint;
        }

        public String getMerchantId() {
            return this.merchantId;
        }

        public String getMerchantSerialNumber() {
            return this.merchantSerialNumber;
        }

        public String getMerchantPrivateKey() {
            return this.merchantPrivateKey;
        }

        public String getApiV3Key() {
            return this.apiV3Key;
        }

        public void setEndpoint(@Nullable String endpoint) {
            this.endpoint = endpoint;
        }

        public void setMerchantId(String merchantId) {
            this.merchantId = merchantId;
        }

        public void setMerchantSerialNumber(String merchantSerialNumber) {
            this.merchantSerialNumber = merchantSerialNumber;
        }

        public void setMerchantPrivateKey(String merchantPrivateKey) {
            this.merchantPrivateKey = merchantPrivateKey;
        }

        public void setApiV3Key(String apiV3Key) {
            this.apiV3Key = apiV3Key;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                return false;
            }
            String this$merchantId = this.getMerchantId();
            String other$merchantId = other.getMerchantId();
            if (this$merchantId == null ? other$merchantId != null : !this$merchantId.equals(other$merchantId)) {
                return false;
            }
            String this$merchantSerialNumber = this.getMerchantSerialNumber();
            String other$merchantSerialNumber = other.getMerchantSerialNumber();
            if (this$merchantSerialNumber == null ? other$merchantSerialNumber != null : !this$merchantSerialNumber.equals(other$merchantSerialNumber)) {
                return false;
            }
            String this$merchantPrivateKey = this.getMerchantPrivateKey();
            String other$merchantPrivateKey = other.getMerchantPrivateKey();
            if (this$merchantPrivateKey == null ? other$merchantPrivateKey != null : !this$merchantPrivateKey.equals(other$merchantPrivateKey)) {
                return false;
            }
            String this$apiV3Key = this.getApiV3Key();
            String other$apiV3Key = other.getApiV3Key();
            return !(this$apiV3Key == null ? other$apiV3Key != null : !this$apiV3Key.equals(other$apiV3Key));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            String $merchantId = this.getMerchantId();
            result = result * 59 + ($merchantId == null ? 43 : $merchantId.hashCode());
            String $merchantSerialNumber = this.getMerchantSerialNumber();
            result = result * 59 + ($merchantSerialNumber == null ? 43 : $merchantSerialNumber.hashCode());
            String $merchantPrivateKey = this.getMerchantPrivateKey();
            result = result * 59 + ($merchantPrivateKey == null ? 43 : $merchantPrivateKey.hashCode());
            String $apiV3Key = this.getApiV3Key();
            result = result * 59 + ($apiV3Key == null ? 43 : $apiV3Key.hashCode());
            return result;
        }

        public String toString() {
            return "WechatPayClientFactory.Config(endpoint=" + this.getEndpoint() + ", merchantId=" + this.getMerchantId() + ", merchantSerialNumber=" + this.getMerchantSerialNumber() + ", merchantPrivateKey=" + this.getMerchantPrivateKey() + ", apiV3Key=" + this.getApiV3Key() + ")";
        }
    }
}

