/*
 * Decompiled with CFR 0.152.
 */
package org.beast.payment.channel.wechatv3;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import com.wechat.pay.contrib.apache.httpclient.exception.ParseException;
import com.wechat.pay.contrib.apache.httpclient.exception.ValidationException;
import com.wechat.pay.contrib.apache.httpclient.util.AesUtil;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.httpclient.ApacheHttpClient;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import org.apache.http.client.HttpClient;
import org.beast.payment.channel.wechatv3.WechatPayNotifyHandler;
import org.beast.payment.channel.wechatv3.WechatPrivateKeySigner;
import org.beast.payment.channel.wechatv3.api.CreateTransactionOfJSAPIInput;
import org.beast.payment.channel.wechatv3.api.CreateTransactionOfJSAPIOutput;
import org.beast.payment.channel.wechatv3.api.WechatV3PayHttpClient;
import org.beast.payment.channel.wechatv3.model.WechatNotifyRequest;
import org.beast.payment.channel.wechatv3.model.WechatPayNotify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.support.SpringMvcContract;

public class WechatPayClient {
    private static final Logger log = LoggerFactory.getLogger(WechatPayClient.class);
    private String merchantId;
    private WechatPrivateKeySigner signer;
    private Verifier verifier;
    private AesUtil aesUtil;
    private WechatV3PayHttpClient httpClient;
    private WechatPayNotifyHandler notifyHandler;

    public WechatPayClient(String merchantId, String endpoint, WechatPrivateKeySigner signer, Verifier verifier, AesUtil aesUtil, WechatPayHttpClientBuilder builder) {
        this.merchantId = merchantId;
        this.signer = signer;
        this.verifier = verifier;
        this.notifyHandler = new WechatPayNotifyHandler(verifier);
        this.aesUtil = aesUtil;
        ApacheHttpClient httpClient = new ApacheHttpClient((HttpClient)builder.build());
        ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).registerModule((Module)new JavaTimeModule());
        this.httpClient = (WechatV3PayHttpClient)Feign.builder().client((Client)httpClient).contract((Contract)new SpringMvcContract()).encoder((Encoder)new JacksonEncoder(mapper)).decoder((Decoder)new JacksonDecoder(mapper)).target(WechatV3PayHttpClient.class, endpoint);
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String sign(String message) {
        return this.signer.sign(message);
    }

    public final boolean validate(String serial, String message, String signature) {
        try {
            if (!this.verifier.verify(serial, message.getBytes(StandardCharsets.UTF_8), signature)) {
                throw WechatPayClient.verifyFail("serial=[%s] message=[%s] sign=[%s]", serial, message, signature);
            }
        }
        catch (IllegalArgumentException e) {
            log.warn(e.getMessage());
            return false;
        }
        return true;
    }

    public WechatPayNotify parsePayNotify(WechatNotifyRequest request) throws ValidationException, IOException, ParseException {
        return this.notifyHandler.parse(request);
    }

    public <T> T decryptData(WechatPayNotify notify, Class<T> clazz) throws ParseException, JsonProcessingException {
        String decryptData;
        WechatPayNotify.Resource resource = notify.getResource();
        String getAssociateddData = "";
        if (resource.getAssociatedData() != null) {
            getAssociateddData = resource.getAssociatedData();
        }
        byte[] associatedData = getAssociateddData.getBytes(StandardCharsets.UTF_8);
        byte[] nonce = resource.getNonce().getBytes(StandardCharsets.UTF_8);
        String ciphertext = resource.getCiphertext();
        try {
            decryptData = this.aesUtil.decryptToString(associatedData, nonce, ciphertext);
        }
        catch (GeneralSecurityException e) {
            throw new ParseException("AES\u89e3\u5bc6\u5931\u8d25\uff0cresource\uff1a" + resource, (Throwable)e);
        }
        return this.notifyHandler.decode(decryptData, clazz);
    }

    protected static IllegalArgumentException verifyFail(String message, Object ... args) {
        message = String.format(message, args);
        return new IllegalArgumentException("signature verify fail: " + message);
    }

    public CreateTransactionOfJSAPIOutput createTransactionOfJSAPI(CreateTransactionOfJSAPIInput input) {
        return this.httpClient.createTransactionOfJSAPI(input);
    }
}

