/*
 * Decompiled with CFR 0.152.
 */
package org.beast.payment.channel.wechat.api.model;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class BaseRequest {
    @XmlElement(name="appid")
    private String appId;
    @XmlElement(name="mch_id")
    private String mchId;
    @XmlElement(name="nonce_str")
    private String nonceStr;
    @XmlElement(name="sign")
    private String sign;
    @XmlElement(name="sign_type")
    private String signType = "HMAC-SHA256";

    @XmlTransient
    public String getAppId() {
        return this.appId;
    }

    @XmlTransient
    public String getMchId() {
        return this.mchId;
    }

    @XmlTransient
    public String getNonceStr() {
        return this.nonceStr;
    }

    @XmlTransient
    public String getSign() {
        return this.sign;
    }

    @XmlTransient
    public String getSignType() {
        return this.signType;
    }

    public Map<String, String> getSignParams() {
        HashMap params = Maps.newHashMap();
        params.put("appid", this.appId);
        params.put("mch_id", this.mchId);
        params.put("nonce_str", this.nonceStr);
        params.put("sign_type", this.signType);
        return params.entrySet().stream().filter(item -> Objects.nonNull(item.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }
}

