/*
 * Decompiled with CFR 0.152.
 */
package org.beast.payment.channel.wechat;

import javax.validation.constraints.NotBlank;
import org.beast.payment.channel.AbstractClientFactory;
import org.beast.payment.channel.wechat.WechatPayV2Client;
import org.beast.payment.channel.wechat.WechatSignType;

public class WechatPayV2ClientFactory
extends AbstractClientFactory<WechatPayV2Client, Config> {
    public static final WechatSignType SIGN_TYPE = WechatSignType.MD5;
    public static final String SANDBOX_TARGET = "https://api.mch.weixin.qq.com/sandboxnew/";
    public static final String TARGET = "https://api.mch.weixin.qq.com";
    public static final String APP_ID_NAME = "appId";
    public static final String KEY_NAME = "key";
    public static final String DOMAIN_NAME = "domain";

    @Override
    public WechatPayV2Client newClient(Config config) {
        WechatPayV2Client client = new WechatPayV2Client(config.endpoint);
        client.setAppId(config.appId);
        client.setKey(config.key);
        client.setMchId(config.mchId);
        return client;
    }

    public static class Config {
        @NotBlank
        private String endpoint;
        @NotBlank
        private String appId;
        @NotBlank
        private String key;
        @NotBlank
        private String mchId;
        @NotBlank
        private String domain;

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getKey() {
            return this.key;
        }

        public String getMchId() {
            return this.mchId;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setMchId(String mchId) {
            this.mchId = mchId;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }
    }
}

