/*
 * Decompiled with CFR 0.152.
 */
package org.beast.payment.channel.wechat;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.beast.payment.channel.wechat.WechatSignType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WechatPayUtils {
    private static final Logger log = LoggerFactory.getLogger(WechatPayUtils.class);
    private static final String FIELD_SIGN = "sign";

    private static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        return documentBuilderFactory.newDocumentBuilder();
    }

    private static Document newDocument() throws ParserConfigurationException {
        return WechatPayUtils.newDocumentBuilder().newDocument();
    }

    public static Map<String, String> xmlToMap(String strXML) throws Exception {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            DocumentBuilder documentBuilder = WechatPayUtils.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(strXML.getBytes("UTF-8"));
            Document doc = documentBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            for (int idx = 0; idx < nodeList.getLength(); ++idx) {
                Node node = nodeList.item(idx);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                data.put(element.getNodeName(), element.getTextContent());
            }
            try {
                ((InputStream)stream).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return data;
        }
        catch (Exception ex) {
            WechatPayUtils.getLogger().warn("Invalid XML, can not convert to map. Error message: {}. XML content: {}", (Object)ex.getMessage(), (Object)strXML);
            throw ex;
        }
    }

    public static boolean isSignatureValid(Map<String, String> params, String key, WechatSignType signType) {
        if (!params.containsKey(FIELD_SIGN)) {
            log.warn("sign is empty");
            return false;
        }
        HashMap contentParams = Maps.newHashMap(params);
        String sign = (String)contentParams.remove(FIELD_SIGN);
        return WechatPayUtils.generateSignature(contentParams, key, signType).equalsIgnoreCase(sign);
    }

    public static String generateSignature(Map<String, String> params, String key, WechatSignType signType) {
        List items = params.entrySet().stream().sorted(new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        }).filter(item -> !Strings.isNullOrEmpty((String)((String)item.getValue()))).map(item -> (String)item.getKey() + "=" + (String)item.getValue()).collect(Collectors.toList());
        String content = Joiner.on((String)"&").join(items) + "&key=" + key;
        switch (signType) {
            case MD5: {
                return DigestUtils.md5Hex((String)content);
            }
            case HMACSHA256: {
                return new HmacUtils(HmacAlgorithms.HMAC_SHA_256, key).hmacHex(content);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid sing type: %s", new Object[]{signType}));
    }

    public static Logger getLogger() {
        return LoggerFactory.getLogger((String)"wxpay java sdk");
    }

    public static String returnNotifySuccess() {
        return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
    }

    public static String returnNotifyFailure(String msg) {
        return "<xml><return_code><![CDATA[FAILURE]]></return_code><return_msg><![CDATA[" + msg + "]]></return_msg></xml>";
    }
}

