/*
 * Decompiled with CFR 0.152.
 */
package org.beast.payment.channel.paypal;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.paypal.base.rest.APIContext;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.beast.payment.channel.AbstractClientFactory;
import org.beast.payment.channel.paypal.PayPalClient;
import org.springframework.beans.factory.annotation.Value;

public class PayPalClientFactory
extends AbstractClientFactory<PayPalClient, Config> {
    public static final String SANDBOX_MODE = "sandbox";
    public static final String MODE = "live";
    public static final String IPN_SANDBOX_ENDPOINT = "https://www.sandbox.paypal.com/cgi-bin/webscr";
    public static final String IPN_ENDPOINT = "https://www.paypal.com/cgi-bin/webscr";
    @Value(value="${spring.profiles.active}")
    private String active;
    public static final String IPN_ENDPOINT_NAME = "ipnEndpoint";
    public static final String DOMAIN_NAME = "domain";

    @Override
    public PayPalClient newClient(Config config) {
        String clientId = config.getClientId();
        String secret = config.getSecret();
        String mode = config.getMode();
        HashMap configurations = Maps.newHashMap();
        if (!Strings.isNullOrEmpty((String)config.getEndpoint())) {
            configurations.put("service.EndPoint", config.getEndpoint());
        }
        APIContext context = new APIContext(clientId, secret, mode, (Map)configurations);
        return new PayPalClient(context);
    }

    public static final class Config {
        @NotBlank
        private String clientId;
        @NotBlank
        private String secret;
        @NotBlank
        private String mode;
        private String endpoint;
        @NotBlank
        private String ipnEndpoint;
        @NotBlank
        private String domain;

        public String getClientId() {
            return this.clientId;
        }

        public String getSecret() {
            return this.secret;
        }

        public String getMode() {
            return this.mode;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getIpnEndpoint() {
            return this.ipnEndpoint;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setIpnEndpoint(String ipnEndpoint) {
            this.ipnEndpoint = ipnEndpoint;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }
    }
}

