/*
 * Decompiled with CFR 0.152.
 */
package org.beast.payment.channel.bytedanceapp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Objects;
import org.beast.payment.channel.bytedanceapp.BytedanceAppNotifyVerifier;
import org.beast.payment.channel.bytedanceapp.exception.BytedanceAppPayException;
import org.beast.payment.channel.bytedanceapp.model.BytedanceAppNotifyRequest;
import org.beast.payment.channel.bytedanceapp.model.BytedanceAppPayNotify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytedanceAppPayNotifyHandler {
    private static final Logger log = LoggerFactory.getLogger(BytedanceAppPayNotifyHandler.class);
    private ObjectMapper mapper;
    private BytedanceAppNotifyVerifier verifier;

    public BytedanceAppPayNotifyHandler(BytedanceAppNotifyVerifier verifier) {
        this.verifier = verifier;
        this.mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).registerModule((Module)new JavaTimeModule());
    }

    public BytedanceAppPayNotify parse(BytedanceAppNotifyRequest request) throws BytedanceAppPayException, JsonProcessingException {
        String type = request.getType();
        if (!Objects.equals(type, "payment")) {
            throw new BytedanceAppPayException("bytedance notify type is not 'payment'");
        }
        if (!this.verifier.verify(request)) {
            throw new BytedanceAppPayException("bytedance notify verify failure");
        }
        String message = request.getMsg();
        return this.parseMessage(message);
    }

    private BytedanceAppPayNotify parseMessage(String message) throws JsonProcessingException {
        return (BytedanceAppPayNotify)this.mapper.readValue(message, BytedanceAppPayNotify.class);
    }
}

