/*
 * Decompiled with CFR 0.152.
 */
package org.beast.payment.channel.bytedanceapp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.util.Map;
import org.beast.payment.channel.bytedanceapp.BytedanceAppKeySigner;
import org.beast.payment.channel.bytedanceapp.BytedanceAppNotifyVerifier;
import org.beast.payment.channel.bytedanceapp.BytedanceAppPayNotifyHandler;
import org.beast.payment.channel.bytedanceapp.api.BytedanceAppPayHttpClient;
import org.beast.payment.channel.bytedanceapp.api.CreateOrderInput;
import org.beast.payment.channel.bytedanceapp.api.CreateOrderOutput;
import org.beast.payment.channel.bytedanceapp.exception.BytedanceAppPayException;
import org.beast.payment.channel.bytedanceapp.model.BytedanceAppNotifyRequest;
import org.beast.payment.channel.bytedanceapp.model.BytedanceAppPayNotify;
import org.springframework.cloud.openfeign.support.SpringMvcContract;

public class BytedanceAppPayClient {
    private String appId;
    private BytedanceAppKeySigner signer;
    private BytedanceAppNotifyVerifier notifyVerifier;
    private BytedanceAppPayNotifyHandler notifyHandler;
    private BytedanceAppPayHttpClient httpClient;
    private ObjectMapper mapper;
    private static final String ENDPOINT = "https://developer.toutiao.com";

    public BytedanceAppPayClient(String appId, String key, String token) {
        this.appId = appId;
        this.signer = new BytedanceAppKeySigner(key);
        this.notifyVerifier = new BytedanceAppNotifyVerifier(token);
        this.notifyHandler = new BytedanceAppPayNotifyHandler(this.notifyVerifier);
        this.mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).registerModule((Module)new JavaTimeModule());
        this.httpClient = (BytedanceAppPayHttpClient)Feign.builder().contract((Contract)new SpringMvcContract()).encoder((Encoder)new JacksonEncoder(this.mapper)).decoder((Decoder)new JacksonDecoder(this.mapper)).target(BytedanceAppPayHttpClient.class, ENDPOINT);
    }

    public CreateOrderOutput createOrder(CreateOrderInput input) {
        Map<String, Object> params = this.buildRequestParams(input);
        return this.httpClient.createOrder(params);
    }

    public BytedanceAppPayNotify parsePayNotify(BytedanceAppNotifyRequest request) throws BytedanceAppPayException, JsonProcessingException {
        return this.notifyHandler.parse(request);
    }

    private Map<String, Object> buildRequestParams(Object input) {
        JsonNode node = this.mapper.valueToTree(input);
        Map params = (Map)this.mapper.treeToValue((TreeNode)node, Map.class);
        String sign = this.signer.sign(params);
        params.put("app_id", this.appId);
        params.put("sign", sign);
        return params;
    }
}

