/*
 * Decompiled with CFR 0.152.
 */
package org.beast.payment.channel.bytedanceapp;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.beast.payment.channel.bytedanceapp.model.BytedanceAppNotifyRequest;

public class BytedanceAppNotifyVerifier {
    private String token;

    public BytedanceAppNotifyVerifier(String token) {
        this.token = token;
    }

    public boolean verify(BytedanceAppNotifyRequest request) {
        Integer timestamp = request.getTimestamp();
        String nonce = request.getNonce();
        String msg = request.getMsg();
        ArrayList values = Lists.newArrayList();
        values.add(this.token);
        values.add(String.valueOf(timestamp));
        values.add(nonce);
        values.add(msg);
        Collections.sort(values);
        String content = Joiner.on((String)"").join((Iterable)values);
        String signature = Hashing.sha1().hashString((CharSequence)content, Charsets.UTF_8).toString();
        String messageSignature = request.getMsgSignature();
        return Objects.equals(signature, messageSignature);
    }
}

