/*
 * Decompiled with CFR 0.152.
 */
package org.beast.payment.channel.alipay;

import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.validation.constraints.NotBlank;
import org.beast.payment.channel.AbstractClientFactory;

public class AlipayClientFactory
extends AbstractClientFactory<AlipayClient, Config> {
    public static final String SANDBOX_TARGET = "https://openapi.alipaydev.com/gateway.do";
    public static final String TARGET = "https://openapi.alipay.com/gateway.do";
    private static final String METHOD = "alipay.trade.page.pay";
    private static final String FORMAT = "json";
    public static final String CHARSET = "utf-8";
    public static final String SIGN_TYPE = "RSA2";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.of("UTC+08:00"));
    private static final String VERSION = "1.0";
    public static final String APP_ID_NAME = "appId";
    public static final String ALIPAY_PUBLIC_KEY_NAME = "alipayPublicKey";
    public static final String DOMAIN_NAME = "domain";

    @Override
    public AlipayClient newClient(Config config) {
        String endpoint = config.endpoint;
        String appId = config.appId;
        String privateKey = config.privateKey;
        String publicKey = config.alipayPublicKey;
        return new DefaultAlipayClient(endpoint, appId, privateKey, FORMAT, CHARSET, publicKey, SIGN_TYPE);
    }

    public static final class Config {
        @NotBlank
        private String endpoint;
        @NotBlank
        private String appId;
        @NotBlank
        private String privateKey;
        @NotBlank
        private String alipayPublicKey;
        @NotBlank
        private String domain;

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public String getAlipayPublicKey() {
            return this.alipayPublicKey;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public void setAlipayPublicKey(String alipayPublicKey) {
            this.alipayPublicKey = alipayPublicKey;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }
    }
}

