package org.beast.payment.notify;


import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.beast.pay.data.notify.NotifyCarry;

import java.io.IOException;
import java.net.URI;

@Slf4j
public class HttpNotifier implements Notifier {


    private final HttpClient client;

    private ObjectMapper objectMapper;

    public HttpNotifier(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.client = HttpClientBuilder.create().build();
    }
    public HttpNotifier() {
        this(new ObjectMapper());
    }

    @Override
    public NotifyReturn send(URI target, NotifyCarry<?> notify) throws IOException {

//        Map<String, Object> params = notify.post();


        String body = objectMapper.writeValueAsString(notify);



        EntityBuilder entityBuilder = EntityBuilder.create()
                .setContentType(ContentType.APPLICATION_JSON)
                .setText(body);


        HttpPost httpPost = new HttpPost(target);
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(6 * 1000)
                .setSocketTimeout(8 * 1000)
                .build();
        httpPost.setConfig(requestConfig);
        httpPost.setEntity(entityBuilder.build());


        NotifyReturn result = NotifyReturn.newOf(notify);

        HttpResponse response = this.client.execute(httpPost);
        String responseString = EntityUtils.toString(response.getEntity());
        boolean success = "success".equals(responseString);

        if (success) {
            result.setResult(NotifyResult.SUCCESS);
        } else {
            result.setResult(NotifyResult.FAILURE);
            result.setException("response != 'success'， value '" + responseString + "'");
            log.warn("response != 'success' , notifyId:{} target: {}  response:{}", notify.getId(), target, responseString);
        }

        return result;
    }
}
