package org.beast.payment.notify;

import org.beast.pay.data.notify.NotifyCarry;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.web.util.UriComponentsBuilder;

import java.io.IOException;
import java.net.URI;

public class CompatibleNotifier implements Notifier{

    private HttpNotifier httpNotifier;

    private LoadBalancerClient loadBalancerClient;

    public CompatibleNotifier(HttpNotifier httpNotifier, LoadBalancerClient loadBalancerClient) {
        this.httpNotifier = httpNotifier;
        this.loadBalancerClient = loadBalancerClient;
    }

    @Override
    public NotifyReturn send(URI target, NotifyCarry<?> notify) throws IOException {
        //识别lb 进行负载均衡的发现

        target = filter(target, notify);
        String scheme = target.getScheme();
        if ("http".equals(scheme) || "https".equals(scheme)) {
            return httpNotifier.send(target, notify);
        }
        throw new IllegalArgumentException("target invalid:" + target);
    }

    private URI filter(URI target, NotifyCarry<?> notify) {
        String scheme = target.getScheme();

        if ("lb".equals(scheme)) {
            ServiceInstance instance = choose(target.getHost());
            if (instance == null) {
                throw new IllegalStateException("unable to find instance for " + target.getHost());
            }
            String overrideScheme = instance.isSecure() ? "https" : "http";
            return UriComponentsBuilder.fromUri(target).scheme(overrideScheme).host(instance.getHost()).port(instance.getPort()).build().toUri();
        }
        return target;
    }

    protected ServiceInstance choose(String host) {
        return loadBalancerClient.choose(host);
    }
}
