package org.beast.pay.data.notify;

import org.beast.pay.data.RefundState;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.Instant;

@Getter @Setter
public class RefundMessage implements NotifyBody{

    //交易号
    private String tradeNo;

    //应用交易号
    private String outTradeNo;

    //退款单号
    private String refundNo;

    //应用退款单号
    private String outRefundNo;

    //退款渠道类型
    private String channelType;

    //退款-货币
    private String currency;

    //退款-金额
    private BigDecimal amount;

    //退款-状态
    private RefundState refundStatus;

    //退款-完成时间
    private Instant refundedAt;


}
