package org.beast.pay.data.notify;

import lombok.Data;
import org.beast.pay.data.*;

import java.time.Instant;

@Data
public class PaymentMessage implements NotifyBody{

    //交易号
    private String id;

    /**
     * The API caller-provided external ID.
     */
    private String outId;

    /**
     * The API caller-provided external ID.
     */
    private String invoiceId;

    //支付类型
    private PaymentMethod method;

    private PaymentChannel channel;


    //货币 金额
    private Money amount;

    //支付者
    private Payer payer;

    //支付时间
    private Instant paidAt;

    //交易状态
    private PaymentState state;


    //渠道支付ID
    private String channelPaymentId;


}
