package org.beast.pay.data.dto;

import com.google.common.collect.Maps;
import lombok.*;
import org.beast.pay.data.Money;
import org.beast.pay.data.PaymentMethod;
import org.beast.pay.data.PaymentSceneInfo;
import org.springframework.lang.Nullable;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.Instant;
import java.util.Map;

@Getter
@Setter
@Builder
@NoArgsConstructor()
@AllArgsConstructor()
public class AppCreatePaymentInput {

//    @NotBlank(message = "PAYMENT_ERR_PARAMETER_BAD")
    private String outId;

    private String invoiceId;

    @NotBlank(message = "PAYMENT_ERR_PARAMETER_BAD")
    private String subject;

    private String body;

    /**
     * 指定渠道ID，则不进行支付路由。
     * 用在提前查询支付路由。并根据配置设置extra的情况
     */
    @Nullable
    private String channelId;

    //支付渠道：微信，支付宝，-支付模式:
    @NotNull(message = "PAYMENT_ERR_PARAMETER_BAD")
    private PaymentMethod method;

    @NotNull(message = "PAYMENT_ERR_PARAMETER_BAD")
    private Money amount;


    /**
     * 支付场景信息
     */
    private PaymentSceneInfo scene;

    private Map<String, String> extra = Maps.newHashMap();
//
//    /**
//     * 简单时间段格式 允许最小单位m
//     */
//    @DurationFormat(value = DurationStyle.SIMPLE)
//    private Ins timeout;

    private Instant expireAt;

    //通知目标
    @Nullable
    private String notifyTarget;
//
//    //创建交易的用户IP
//    @NotNull(message = "PAYMENT_ERR_PARAMETER_BAD")
//    private String createUserIp;


}
