package org.beast.pay.data.convert;

import org.beast.pay.data.PaymentSymbol;
import org.beast.pay.data.PaymentMethod;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;

import java.util.ArrayList;
import java.util.List;

public class PaymentConverters {
    private PaymentConverters() {}

    public static List<Converter<?, ?>> getConvertersToRegister() {
        List<Converter<?, ?>> converts = new ArrayList<>();
        converts.add(StringToPaymentSymbolConvert.INSTANCE);
        converts.add(PaymentSymbolToStringConvert.INSTANCE);
        converts.add(StringToPaymentTypeConvert.INSTANCE);
        converts.add(PaymentTypeToStringConvert.INSTANCE);
        return converts;
    }

    static enum StringToPaymentSymbolConvert implements Converter<String, PaymentSymbol> {
        INSTANCE;

        @Override
        public PaymentSymbol convert(@Nullable String source) {
            return source == null ? null : new PaymentSymbol(source);
        }
    }

    static enum PaymentSymbolToStringConvert implements Converter<PaymentSymbol, String> {
        INSTANCE;

        @Override
        public String convert(@Nullable PaymentSymbol source) {
            return source == null ? null : source.toString();
        }
    }

    static enum StringToPaymentTypeConvert implements Converter<String, PaymentMethod> {
        INSTANCE;

        @Override
        public PaymentMethod convert(@Nullable String source) {
            return source == null ? null : PaymentMethod.valueOf(source);
        }
    }

    static enum PaymentTypeToStringConvert implements Converter<PaymentMethod, String> {
        INSTANCE;

        @Override
        public String convert(@Nullable PaymentMethod source) {
            return source == null ? null : source.toString();
        }
    }
}
