package org.beast.pay.data;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;
import org.springframework.lang.Nullable;

import javax.validation.constraints.NotBlank;

/**
 * 支付模式场景下的参数
 */
@Builder
@Data
public class WechatpaySceneInfo implements PaymentSceneInfo {


    @NotBlank()
    private String appid;

    @NotBlank(groups = JSAPI.class)
    private String openid;

    //用户终端IP
    @NotBlank(groups = H5.class)
    private String payerClientIp;

    //iOS, Android, Waps
    @NotBlank(groups = H5.class)
    private String h5Type;


    /**
     * H5支付 设置redirect_url后,回跳指定页面的操作可能发生在：
     * 1、微信支付中间页调起微信收银台后超过5秒
     * 2、用户点击“取消支付”或支付完成后点击“完成”按钮。因此无法保证页面回跳时，支付流程已结束，所以商户设置的redirect_url地址不能自动执行查单操作，应让用户去点击按钮触发查单操作，回跳页面展示效果可参考下图
     */
    @Nullable
    private String redirectUrl;

    @Tolerate
    public WechatpaySceneInfo() {
    }

    interface H5 {

    }
    interface JSAPI {

    }

    interface Native {

    }
}
