package org.beast.pay.data;

import lombok.Data;
import org.springframework.lang.Nullable;

import javax.validation.constraints.NotBlank;

/**
 * 支付模式场景下的参数
 */
@Data
public class AlipaySceneInfo implements PaymentSceneInfo{

    @Nullable
    private String requestFromUrl;

//    @NotBlank(groups = {WAP.class})
    /**
     * 用于取消支付后退页面
     * - WAP
     */
    @Nullable
    private String quitUrl;

//    @NotBlank(groups = {WAP.class, PAGE.class})
    /**
     * 用于支付完成同步回调
     * - WAP
     * - Page
     */
    //同步回调，允许为空，由payment 维护
    @Nullable
    private String returnUrl;


    interface WAP {

    }
    interface PAGE {

    }
}
