/*
 * Decompiled with CFR 0.152.
 */
package org.beast.pay.data.dto;

import com.google.common.collect.Maps;
import java.time.Instant;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.beast.pay.data.Money;
import org.beast.pay.data.PaymentMethod;
import org.beast.pay.data.PaymentSceneInfo;
import org.springframework.lang.Nullable;

public class AppCreatePaymentInput {
    private String outId;
    private String invoiceId;
    @NotBlank(message="PAYMENT_ERR_PARAMETER_BAD")
    private @NotBlank(message="PAYMENT_ERR_PARAMETER_BAD") String subject;
    private String body;
    @Nullable
    private String channelId;
    @NotNull(message="PAYMENT_ERR_PARAMETER_BAD")
    private @NotNull(message="PAYMENT_ERR_PARAMETER_BAD") PaymentMethod method;
    @NotNull(message="PAYMENT_ERR_PARAMETER_BAD")
    private @NotNull(message="PAYMENT_ERR_PARAMETER_BAD") Money amount;
    private PaymentSceneInfo scene;
    private Map<String, String> extra = Maps.newHashMap();
    private Instant expireAt;
    @Nullable
    private String notifyTarget;

    public static AppCreatePaymentInputBuilder builder() {
        return new AppCreatePaymentInputBuilder();
    }

    public String getOutId() {
        return this.outId;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    @Nullable
    public String getChannelId() {
        return this.channelId;
    }

    public PaymentMethod getMethod() {
        return this.method;
    }

    public Money getAmount() {
        return this.amount;
    }

    public PaymentSceneInfo getScene() {
        return this.scene;
    }

    public Map<String, String> getExtra() {
        return this.extra;
    }

    public Instant getExpireAt() {
        return this.expireAt;
    }

    @Nullable
    public String getNotifyTarget() {
        return this.notifyTarget;
    }

    public void setOutId(String outId) {
        this.outId = outId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setChannelId(@Nullable String channelId) {
        this.channelId = channelId;
    }

    public void setMethod(PaymentMethod method) {
        this.method = method;
    }

    public void setAmount(Money amount) {
        this.amount = amount;
    }

    public void setScene(PaymentSceneInfo scene) {
        this.scene = scene;
    }

    public void setExtra(Map<String, String> extra) {
        this.extra = extra;
    }

    public void setExpireAt(Instant expireAt) {
        this.expireAt = expireAt;
    }

    public void setNotifyTarget(@Nullable String notifyTarget) {
        this.notifyTarget = notifyTarget;
    }

    public AppCreatePaymentInput() {
    }

    public AppCreatePaymentInput(String outId, String invoiceId, String subject, String body, @Nullable String channelId, PaymentMethod method, Money amount, PaymentSceneInfo scene, Map<String, String> extra, Instant expireAt, @Nullable String notifyTarget) {
        this.outId = outId;
        this.invoiceId = invoiceId;
        this.subject = subject;
        this.body = body;
        this.channelId = channelId;
        this.method = method;
        this.amount = amount;
        this.scene = scene;
        this.extra = extra;
        this.expireAt = expireAt;
        this.notifyTarget = notifyTarget;
    }

    public static class AppCreatePaymentInputBuilder {
        private String outId;
        private String invoiceId;
        private String subject;
        private String body;
        private String channelId;
        private PaymentMethod method;
        private Money amount;
        private PaymentSceneInfo scene;
        private Map<String, String> extra;
        private Instant expireAt;
        private String notifyTarget;

        AppCreatePaymentInputBuilder() {
        }

        public AppCreatePaymentInputBuilder outId(String outId) {
            this.outId = outId;
            return this;
        }

        public AppCreatePaymentInputBuilder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public AppCreatePaymentInputBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public AppCreatePaymentInputBuilder body(String body) {
            this.body = body;
            return this;
        }

        public AppCreatePaymentInputBuilder channelId(@Nullable String channelId) {
            this.channelId = channelId;
            return this;
        }

        public AppCreatePaymentInputBuilder method(PaymentMethod method) {
            this.method = method;
            return this;
        }

        public AppCreatePaymentInputBuilder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        public AppCreatePaymentInputBuilder scene(PaymentSceneInfo scene) {
            this.scene = scene;
            return this;
        }

        public AppCreatePaymentInputBuilder extra(Map<String, String> extra) {
            this.extra = extra;
            return this;
        }

        public AppCreatePaymentInputBuilder expireAt(Instant expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        public AppCreatePaymentInputBuilder notifyTarget(@Nullable String notifyTarget) {
            this.notifyTarget = notifyTarget;
            return this;
        }

        public AppCreatePaymentInput build() {
            return new AppCreatePaymentInput(this.outId, this.invoiceId, this.subject, this.body, this.channelId, this.method, this.amount, this.scene, this.extra, this.expireAt, this.notifyTarget);
        }

        public String toString() {
            return "AppCreatePaymentInput.AppCreatePaymentInputBuilder(outId=" + this.outId + ", invoiceId=" + this.invoiceId + ", subject=" + this.subject + ", body=" + this.body + ", channelId=" + this.channelId + ", method=" + this.method + ", amount=" + this.amount + ", scene=" + this.scene + ", extra=" + this.extra + ", expireAt=" + this.expireAt + ", notifyTarget=" + this.notifyTarget + ")";
        }
    }
}

