/*
 * Decompiled with CFR 0.152.
 */
package org.beast.pay.data.convert;

import java.util.ArrayList;
import java.util.List;
import org.beast.pay.data.PaymentMethod;
import org.beast.pay.data.PaymentSymbol;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;

public class PaymentConverters {
    private PaymentConverters() {
    }

    public static List<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converts = new ArrayList();
        converts.add(StringToPaymentSymbolConvert.INSTANCE);
        converts.add(PaymentSymbolToStringConvert.INSTANCE);
        converts.add(StringToPaymentTypeConvert.INSTANCE);
        converts.add(PaymentTypeToStringConvert.INSTANCE);
        return converts;
    }

    static enum StringToPaymentSymbolConvert implements Converter<String, PaymentSymbol>
    {
        INSTANCE;


        public PaymentSymbol convert(@Nullable String source) {
            return source == null ? null : new PaymentSymbol(source);
        }
    }

    static enum PaymentSymbolToStringConvert implements Converter<PaymentSymbol, String>
    {
        INSTANCE;


        public String convert(@Nullable PaymentSymbol source) {
            return source == null ? null : source.toString();
        }
    }

    static enum StringToPaymentTypeConvert implements Converter<String, PaymentMethod>
    {
        INSTANCE;


        public PaymentMethod convert(@Nullable String source) {
            return source == null ? null : PaymentMethod.valueOf(source);
        }
    }

    static enum PaymentTypeToStringConvert implements Converter<PaymentMethod, String>
    {
        INSTANCE;


        public String convert(@Nullable PaymentMethod source) {
            return source == null ? null : source.toString();
        }
    }
}

