/*
 * Decompiled with CFR 0.152.
 */
package org.beast.pay.data;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class PaymentSymbol
implements Serializable {
    protected static final String PART_DIVIDER_TOKEN = ":";
    protected static final String WILDCARD_TOKEN = "*";
    protected static final String SUBPART_DIVIDER_TOKEN = ",";
    private String type;
    private Set<String> modes;

    public PaymentSymbol(String symbol) {
        this.parseSymbol(symbol);
    }

    public PaymentSymbol(String type, String mode) {
        this.type = type;
        this.modes = Sets.newHashSet((Object[])new String[]{mode});
    }

    public static PaymentSymbol valueOf(String type, String mode) {
        return new PaymentSymbol(type, mode);
    }

    public static PaymentSymbol valueOf(String method) {
        return new PaymentSymbol(method);
    }

    private void parseSymbol(String symbolString) {
        if (StringUtils.isEmpty((CharSequence)symbolString)) {
            throw new IllegalArgumentException("symbol string cannot be empty");
        }
        Iterable parts = Splitter.on((String)PART_DIVIDER_TOKEN).split((CharSequence)symbolString);
        Iterator partsIter = parts.iterator();
        this.type = (String)partsIter.next();
        this.modes = Sets.newHashSet((Object[])((String)partsIter.next()).split(SUBPART_DIVIDER_TOKEN));
    }

    public boolean implies(String symbol) {
        return this.implies(new PaymentSymbol(symbol));
    }

    public boolean implies(PaymentSymbol symbol) {
        if (!Objects.equals(this.type, symbol.type)) {
            return false;
        }
        return this.modes.contains(WILDCARD_TOKEN) || this.modes.containsAll(symbol.modes);
    }

    public boolean implies(String type, String mode) {
        return this.implies(new PaymentSymbol(type, mode));
    }

    public String toString() {
        return this.type + PART_DIVIDER_TOKEN + Joiner.on((String)SUBPART_DIVIDER_TOKEN).join(this.modes);
    }
}

