/*
 * Decompiled with CFR 0.152.
 */
package org.beast.pay.data;

import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.beast.pay.data.PaymentType;

public class PaymentMethod
implements Serializable {
    static final String PART_DIVIDER_TOKEN = ":";
    private final PaymentType type;
    private final String mode;

    public static PaymentMethod valueOf(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new IllegalArgumentException("string cannot be empty");
        }
        Iterable parts = Splitter.on((String)PART_DIVIDER_TOKEN).split((CharSequence)value);
        Iterator partsIter = parts.iterator();
        PaymentType type = PaymentType.valueOf((String)partsIter.next());
        String mode = (String)partsIter.next();
        return new PaymentMethod(type, mode);
    }

    public static PaymentMethod valueOf(PaymentType type, String mode) {
        return new PaymentMethod(type, mode);
    }

    public String toString() {
        return this.type + PART_DIVIDER_TOKEN + this.mode;
    }

    public PaymentMethod(PaymentType type, String mode) {
        this.type = type;
        this.mode = mode;
    }

    public PaymentType type() {
        return this.type;
    }

    public String mode() {
        return this.mode;
    }
}

