package org.beast.pay.data.notify;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Data;
import org.beast.pay.data.NotifyType;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.Instant;
import java.util.Map;

@Data
public class CreateNotifyInput {

    //应用
    @NotBlank
    private String appId;

    //通知类型
    @NotNull
    private NotifyType type;

    //通知来源ID
    @NotBlank
    private String source;

    //通知目标
    private String target;

    private Map<String, String> metadata;


    @JsonTypeInfo(
            use = JsonTypeInfo.Id.NAME,
            include = JsonTypeInfo.As.EXTERNAL_PROPERTY,
            property = "type",
            visible = true
    )
    @JsonSubTypes({
            @JsonSubTypes.Type(value = PaymentMessage.class, name = "PAYMENT"),
            @JsonSubTypes.Type(value = RefundMessage.class, name = "PAYMENT_REFUND"),
            @JsonSubTypes.Type(value = OrderMessage.class, name = "ORDER"),
    })
    private NotifyBody body;


    private String nonce;

    //通知产生时间
    private Instant time;

}
