package org.beast.pay.data.dto;

import lombok.*;
import lombok.experimental.Tolerate;
import org.beast.pay.data.Money;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Map;


@Builder
@Data
public class AppCreateOrderApply {


    private String outId;

    private String invoiceId;

    @NotBlank(message = "PAY_ERR_PARAMETER_BAD")
    private String subject;

    private String body;

    /**
     * 扩展参数
     */
    private Map<String, String> extra;

    @NotNull(message = "PAYMENT_ERR_PARAMETER_BAD")
    private Money amount;


    @Tolerate
    public AppCreateOrderApply() {

    }
}
