package org.beast.pay.data;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import javax.validation.constraints.NotBlank;

/**
 * 支付模式场景下的参数
 */
@Builder
@Data
public class WechatpaySceneInfo implements PaymentSceneInfo {


    @NotBlank()
    private String appId;

    @NotBlank(groups = JSAPI.class)
    private String openid;

    //用户终端IP
    @NotBlank(groups = H5.class)
    private String payerClientIp;

    //iOS, Android, Waps
    @NotBlank(groups = H5.class)
    private String h5Type;



    @Tolerate
    public WechatpaySceneInfo() {
    }

    interface H5 {

    }
    interface JSAPI {

    }

    interface Native {

    }
}
