package org.beast.pay.data;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class Money {

    private Currency currency;

    private BigDecimal value;

    public Money() {

    }

    public Money(BigDecimal value) {
        this(Currency.CNY, value);
    }
    public Money(Currency currency, BigDecimal value) {
        this.currency = currency;
        this.value = value;
    }

    public Money valueOf(Currency currency, BigDecimal value) {
        return new Money(currency, value);
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Money money = (Money) o;
        return this.compareEqual(money);
    }

    public boolean compareEqual(Money money) {
        return this.currency == money.currency &&
                this.value.compareTo(money.getValue()) == 0;
    }

}
