package org.beast.pay.data;

import lombok.Data;
import org.springframework.lang.Nullable;

import javax.validation.constraints.NotBlank;

/**
 * 支付模式场景下的参数
 */
@Data
public class AlipaySceneInfo implements PaymentSceneInfo{

    @Nullable
    private String requestFromUrl;

    @NotBlank(groups = {WAP.class})
    private String quitUrl;

    @NotBlank(groups = {WAP.class, PAGE.class})
    private String returnUrl;


    interface WAP {

    }
    interface PAGE {

    }
}
