/*
 * Decompiled with CFR 0.152.
 */
package org.beast.pay.data;

import java.math.BigDecimal;
import org.beast.pay.data.Currency;

public class Money {
    private Currency currency;
    private BigDecimal value;

    public Money() {
    }

    public Money(BigDecimal value) {
        this(Currency.CNY, value);
    }

    public Money(Currency currency, BigDecimal value) {
        this.currency = currency;
        this.value = value;
    }

    public Money valueOf(Currency currency, BigDecimal value) {
        return new Money(currency, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Money money = (Money)o;
        return this.compareEqual(money);
    }

    public boolean compareEqual(Money money) {
        return this.currency == money.currency && this.value.compareTo(money.getValue()) == 0;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public String toString() {
        return "Money(currency=" + this.getCurrency() + ", value=" + this.getValue() + ")";
    }
}

