package org.beast.payment.data.notify;

import lombok.Getter;
import lombok.Setter;
import org.beast.payment.data.Money;
import org.beast.payment.data.OrderState;
import org.beast.payment.data.PaymentMethod;

import java.time.Instant;

@Getter @Setter
public class OrderMessage implements NotifyBody{

    //支付订单号
    private String id;


    //支付类型
    private PaymentMethod paymentMethod;

    private String outId;

    //Caller ID
    private String invoiceId;

    private String paymentId;

    private String channelPaymentId;

    //支付时间
    private Instant paidAt;

    //金额
    private Money amount;

    //订单状态
    private OrderState state;

}
