package org.beast.payment.data.notify;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Data;
import org.beast.payment.data.NotifyType;

import javax.validation.constraints.NotBlank;
import java.time.Instant;

@Data
public class NotifyCarry<T> {
    //通知ID
    private String id;

    //应用
    private String appId;

    private NotifyType type;


    @JsonTypeInfo(
            use = JsonTypeInfo.Id.NAME,
            include = JsonTypeInfo.As.EXISTING_PROPERTY,
            property = "type",
            visible = true
    )
    @JsonSubTypes({
            @JsonSubTypes.Type(value = PaymentMessage.class, name = "PAYMENT"),
            @JsonSubTypes.Type(value = RefundMessage.class, name = "PAYMENT_REFUND"),
            @JsonSubTypes.Type(value = OrderMessage.class, name = "ORDER"),
            @JsonSubTypes.Type(value = RefundMessage.class, name = "ORDER_REFUND"),
    })
    private T body;

    //通知时间
    private Instant time;

}
