package org.beast.payment.data;

import com.google.common.base.Splitter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Iterator;

/**
 * querydsl apt 对 record 不够兼容
 */
public class PaymentMethod implements Serializable {

    static final String PART_DIVIDER_TOKEN = ":";


    public static PaymentMethod valueOf(String value) {
        if (StringUtils.isEmpty(value)) {
            throw new IllegalArgumentException("string cannot be empty");
        }
        Iterable<String> parts = Splitter.on(PART_DIVIDER_TOKEN).split(value);
        Iterator<String> partsIter = parts.iterator();
        PaymentType type = PaymentType.valueOf(partsIter.next());
        String mode = partsIter.next();

        return new PaymentMethod(type, mode);
    }

    public static PaymentMethod valueOf(PaymentType type, String mode) {
        return new PaymentMethod(type, mode);
    }

    @Override
    public String toString() {
        return type + PART_DIVIDER_TOKEN + this.mode;
    }

    private final PaymentType type;

    private final String mode;

    public PaymentMethod(PaymentType type, String mode) {
        this.type = type;
        this.mode = mode;
    }


    public PaymentType type() {
        return this.type;
    }
    public String mode() {
        return this.mode;
    }

}
