package org.beast.pay.core;

import lombok.Data;
import org.beast.pay.data.ChannelType;

import java.util.Map;

@Data
public class ChannelDefinition {

    private String id;

    //渠道标识
    private String identifier;
    /**
     * 渠道类型
     */
    private ChannelType channelType;

    //TODO 根据ClientFactory 设置允许路由输出参数
    private Map<String, String> args;


    public String getArgValue(String name) {
        if (args == null) {
            return null;
        }
        return args.get(name);
    }

    public String getNo() {
        return switch (channelType) {
            case BYTEAPPPAY -> getArgValue("appId");
            case WECHATPAYV2 -> getArgValue("mchId");
            case WECHATPAY -> getArgValue("merchantId");
            case ALIPAY -> getArgValue("appId");
            case PAYPAL -> getArgValue("clientId");
        };
    }

}
