package org.beast.payment.core;

import lombok.Getter;
import lombok.Setter;
import org.beast.payment.data.PaymentSymbol;
import org.beast.payment.data.PaymentMethod;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.function.Predicate;

@Getter @Setter
public class Route {

    @NotNull
    private PaymentSymbol symbol;

    @NotBlank
    private String channelId;



    public Predicate<PaymentMethod> getPredicate() {
        PaymentSymbol symbol = this.symbol;
        return new Predicate<PaymentMethod>() {
            @Override
            public boolean test(PaymentMethod paymentType) {
                return symbol.implies(paymentType.type().toString(), paymentType.mode());
            }
        };
    }
}
