package org.beast.payment.core;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.beast.payment.data.PaymentMethod;

import java.util.List;
import java.util.Optional;

@Getter @Setter
@Slf4j
public class PaymentApp {


    private String appId;

    //路由
    private List<Route> routes;


    public String lookup(PaymentMethod method) {
        Optional<Route> routeOptional = routes.stream().filter(route -> {
            return route.getPredicate().test(method);
        }).findFirst();
        if (routeOptional.isEmpty()) {
            return null;
        }
        Route route = routeOptional.get();
        return route.getChannelId();
    }

    public String appId() {
        return this.appId;
    }

    public boolean own(Apped apped) {
        return this.appId.equals(apped.appId());
    }

}
