package org.beast.pay.control.client;


import org.beast.pay.core.PaymentApp;
import org.beast.pay.core.ChannelDefinition;
import org.beast.data.message.ReturnResult;

import org.beast.pay.data.notify.CreateNotifyInput;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Service
@FeignClient("beast-pay-control")
public interface PaymentControlClient {

    @GetMapping("/api/apps/{appId}")
    ReturnResult<PaymentApp> getAppById(
            @PathVariable("appId") String appId
    );

    @GetMapping("/api/channels/{channelId}")
    ReturnResult<ChannelDefinition> getChannelById(
            @PathVariable("channelId") String channelId
    );

    @PostMapping("/api/notifies")
    ReturnResult<?> postNotify(
        @RequestBody() CreateNotifyInput input
    );

}
