package org.beast.pay.client;

import org.beast.data.message.ReturnResult;
import org.beast.pay.data.dto.AppOrderOutput;
import org.beast.pay.data.dto.AppOrderPaymentOutput;
import org.beast.pay.data.dto.AppCreateOrderApply;
import org.beast.pay.data.dto.AppCreateOrderPaymentInput;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

@Service
@FeignClient("beast-pay-checkout")
public interface PayCheckoutClient {

    @PostMapping("/app/api/orders")
    ReturnResult<AppOrderOutput> createOrder(
            @RequestHeader("X-App") String appId,
            @RequestBody AppCreateOrderApply input
    );

    @PostMapping("/app/api/orders/{id}/payments")
    ReturnResult<AppOrderPaymentOutput> createOrderPayment(
            @RequestHeader("X-App") String appId,
            @PathVariable("id") String id,
            @RequestBody AppCreateOrderPaymentInput input
    );

}
