package org.beast.pay.client;


import org.beast.data.message.ReturnResult;
import org.beast.pay.data.dto.AppCreatePaymentInput;
import org.beast.pay.data.dto.AppCreatePaymentOutput;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

@Service
@FeignClient("beast-pay-payment")
public interface PaymentClient {

    @PostMapping("/app/api/payments")
    ReturnResult<AppCreatePaymentOutput> create(
            @RequestHeader("X-App") String appId,
            @RequestBody AppCreatePaymentInput input);
}
