package org.beast.openapp.web.configuration;


import org.beast.openapp.web.AppAccessInterceptor;
import org.beast.openapp.web.AppContextResolver;
import org.beast.openapp.web.resolver.AccessAppHandlerMethodArgumentResolver;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.List;


@ConditionalOnBean(AppContextResolver.class)
@Configuration(proxyBeanMethods = false)
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
public class OpenAppMvcConfiguration implements WebMvcConfigurer {

    private AppContextResolver resolver;

    public OpenAppMvcConfiguration(@Lazy AppContextResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(new AccessAppHandlerMethodArgumentResolver());
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(new AppAccessInterceptor(resolver))
                .addPathPatterns("/app/**");
    }
}
