/*
 * Decompiled with CFR 0.152.
 */
package org.beast.openapp.web.configuration;

import java.util.List;
import org.beast.openapp.web.AppAccessInterceptor;
import org.beast.openapp.web.AppContextResolver;
import org.beast.openapp.web.resolver.AccessAppHandlerMethodArgumentResolver;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnBean(value={AppContextResolver.class})
@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class OpenAppMvcConfiguration
implements WebMvcConfigurer {
    private AppContextResolver resolver;

    public OpenAppMvcConfiguration(@Lazy AppContextResolver resolver) {
        this.resolver = resolver;
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(new AccessAppHandlerMethodArgumentResolver());
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new AppAccessInterceptor(this.resolver)).addPathPatterns(new String[]{"/app/**"});
    }
}

