package org.beast.openapp.web.resolver;

import org.beast.openapp.web.AppAccessInterceptor;
import org.beast.openapp.web.annotation.AccessApp;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class AccessAppHandlerMethodArgumentResolver implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(AccessApp.class);
    }

    @Nullable
    @Override
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        MethodParameter nestedParameter = parameter.nestedIfOptional();
        return webRequest.getAttribute(AppAccessInterceptor.APP_VARIABLES_ATTRIBUTE, RequestAttributes.SCOPE_REQUEST);
    }
}
