package org.beast.openapp.web;

import org.springframework.lang.NonNull;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AppAccessInterceptor implements HandlerInterceptor {

    public static final String APP_VARIABLES_ATTRIBUTE = AppAccessInterceptor.class.getName() + ".app";
    private AppContextResolver resolver;

    public AppAccessInterceptor(AppContextResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public boolean preHandle(@NonNull HttpServletRequest request,@NonNull HttpServletResponse response,@NonNull Object handler) throws Exception {
        Object app = resolver.resolve(request, response);
        request.setAttribute(APP_VARIABLES_ATTRIBUTE, app);
        return true;
    }
}
